/***************************************************************************
 *
 *  Created by Kat Dornian (Phidgets Inc) on 2014-05-31
 *  This file is part of nightlight.
 *  
 *  Nightlight is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  Nightlight is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You can see the GNU General Public License at 
 *  <http://www.gnu.org/licenses/>.
 *                                  _   _ ____  _
 *  Project                     ___| | | |  _ \| |
 *                             / __| | | | |_) | |
 *                            | (__| |_| |  _ <| |___
 *                             \___|\___/|_| \_\_____|
 *
 * Copyright (C) 1998 - 2013, Daniel Stenberg, <daniel@haxx.se>, et al.
 *
 * This software is licensed as described in the file COPYING, which
 * you should have received as part of this distribution. The terms
 * are also available at http://curl.haxx.se/docs/copyright.html.
 *
 * You may opt to use, copy, modify, merge, publish, distribute and/or sell
 * copies of the Software, and permit persons to whom the Software is
 * furnished to do so, under the terms of the COPYING file.
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY
 * KIND, either express or implied.
 *
 * original Search_in_File function found here:
 * http://www.codingunit.com/c-tutorial-searching-for-strings-in-a-text-file
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>

#include "temp.h"

// Open file with fname, return the double pointed to at at_position in the file fname.
double Read_File(char *fname, int at_position) {
	FILE *fp;
	double read_dbl;
	
	// try to open the file, if it doesn't work exit
	if((fp = fopen(fname, "r")) == NULL) {
		fprintf(stderr, "Could not read file\n");
		return(-1);
	}
	
	fseek(fp, at_position, SEEK_SET);
	fscanf(fp, "%lf", &read_dbl);
	
	if(fp) {
		fclose(fp);
	}
	
	return(read_dbl);
}

// Open the file called fname and returns the position of str in fname
int Search_in_File(char *fname, char *str, int strlen) {
	FILE *fp;
	int c;
	int char_num = 0;
	int find_result = 0;

	// try opening the file, if fails, exit
	if((fp = fopen(fname, "r")) == NULL) {
		fprintf(stderr, "Could not read file\n");
		return(-1);
	}
	
	// Once we find a string that matches str then exit the loop and return the position
	while (find_result != strlen)
	{
		c = fgetc(fp);
		
		if( feof(fp) )
		{
			break ;
		}
		
		if(c == str[find_result]) {
			find_result++;
		}
		else {
			find_result = 0;
		}
		
		char_num++;
	}
	
	if(find_result == 0) {
		fprintf(stderr, "\nSorry, couldn't find a match.\n");
	}
	
	//Close the file if still open.
	if(fp) {
		fclose(fp);
	}
	return(char_num - strlen);
}

double Temperature(void)
{
	CURL *curl;
	CURLcode res;
	FILE *weatherfile;
	int pos;
	char filename[] = "weather.txt";
	char curtempstring[] = "200.000";
	double curtemp;
	
	weatherfile = fopen(filename, "w");
	if(weatherfile == NULL) {
		fprintf(stderr, "could not print weather to file\n");
		return 0;
	}
	
	curl = curl_easy_init();
	if(curl) {
		curl_easy_setopt(curl, CURLOPT_URL, "http://api.openweathermap.org/data/2.5/weather?lat=51.056057&lon=-114.077826");
		// example.com is redirected, so we tell libcurl to follow redirection
		curl_easy_setopt(curl, CURLOPT_FOLLOWLOCATION, 1L);
		curl_easy_setopt(curl, CURLOPT_WRITEDATA, weatherfile);
		
		// Perform the request, res will get the return code
		res = curl_easy_perform(curl);
		
		// done writing to file so close it
		fclose(weatherfile);
		
		// Check for errors
		if(res != CURLE_OK)
			fprintf(stderr, "curl_easy_perform() failed: %s\n",
					curl_easy_strerror(res));
		
		// Parse the file to find the first occurance of temp": 
		// and where the actual temp will begin
		pos = Search_in_File(filename, "temp\":", 6) + 6;

		// Get the temperature
		curtemp = Read_File(filename, pos);
		
		// always cleanup
		curl_easy_cleanup(curl);
	}
	return curtemp;
}
